//
// Created by 76538 on 2/3/2021.
//

#ifndef C_IMPLEMENT_NANOVOID_H
#define C_IMPLEMENT_NANOVOID_H

#include <cstdio>
#include <cstdlib>
#include <vector>
#include <list>
#include <iostream>
#include <random>
#include <cmath>
#include <cassert>
#include <algorithm>
#include <set>

#include "union_find_delete.h"
#include "enum_hash.hpp"

using namespace std;


typedef double valueType;
typedef unsigned int uint;


class Coordinate2d {
// 2-dimensional Coordinate of a pixel
public:
 int x, y;

 Coordinate2d(const Coordinate2d &c) :
  x(c.x), y(c.y)
 {}
  
 Coordinate2d(int _x, int _y) :
  x(_x), y(_y)
 {}

  inline void from(const Coordinate2d &c) {
    x = c.x;
    y = c.y;
  }

  inline void from_item(uint item, uint len) {
    x = item / len;
    y = item % len;
  }

  inline uint to_item(uint len) {
    return ((uint)x)*len + ((uint)y);
  }
};


class LocalitySensitiveHashing {
  int seed;
  valueType r;

  uint K, L, arr_len;  // or L (and K lsh)
  
  default_random_engine generator;
  normal_distribution<valueType> nor_dis;
  uniform_real_distribution<valueType> uni_dis;

  valueType* a;
  valueType* b;
  
 public:
  LocalitySensitiveHashing(int _seed, valueType _r, uint _K, uint _L, \
                           uint _arr_len);
  ~LocalitySensitiveHashing();
  
  void lsh(valueType* v, uint wh, int* dest);
  // compute the wh-th (and K lsh); store the values in dest
  // return the lsh hash code with the values of
  // the pixel and neighbors given in valueType* v
  // smch: radius r, array length arr_len
  // lsh = floor((v * a + b) / r)
  //  
};


class HashPointer {
public:
  uint K;
  uint hash_code;                    // the current hash code

  uint pnb;                          // Pointer to the PNBucket (old HashBucket)
  int* lsh_hash_code;                // the current lsh hash code (store the (and K lsh))

  HashPointer(uint K);           //
  HashPointer(const HashPointer& b);
  ~HashPointer();
};


class HashPointerBank {
  uint K;
  list < uint > freed;
  uint num_freed;
 public:
  
  inline uint getK() {
    return K;
  }
  
  vector <HashPointer> d;           
  HashPointerBank(uint _K, uint init_size=1024);
  uint new_elem();               // create an empty element (p_node == UINT_NULL)
  bool free_elem(uint k);        // move the element to freed list (setting p_node = UINT_NULL, but does not change other fields).  
};


class PNBucket{
 public:
  uint p_list;                       // the representative in the inverse table (uint is the item value (converted from Coordinate).
  bool at_least_one_lsh_changed;
  //set< uint > n_list;                // the neighbors' item value (coordinate).
  uint n_list_id;
  
  void merge_with(PNBucket* y, EnumHashTable& n_list_hash, UnionFindDelete &inv);
                                    // TODO: merge the current hashbucket with y
                                    // store the merged result in the current bucket
                                    // keep content in y
};

class PNBucketBank {
  list < uint > freed;
  uint num_freed;
 public:
  vector <PNBucket> d;           
  EnumHashTable n_list_hash;
  PNBucketBank(uint init_size=1024);
  uint new_elem();               // create an empty element (p_node == UINT_NULL)
  bool free_elem(uint k);        // move the element to freed list (setting p_node = UINT_NULL, but does not change other fields).    
};


class HashTable{
public:
  uint K;                            // the length of each lsh code.
  uint L;                            // number of hash tables (or L hashtables).
  uint hash_size;                    // smch: hash prime number for h
  
  vector< vector<uint> > h;          // h[i] is the actual hash table;
                                     // point to location in l[i]
                                     // every empty slot in h will be denoted as UINT_NULL
  
  vector< vector< vector< uint > > > l;   // a double link list,
                                      // record the non-empty entries of
                                      // the hash table h (store the pointer at hp)
  vector< vector< uint > > l2h;        // a double link list,
                                       // record the hash_loc (position in h)
                                       // for all items in l.

  HashPointerBank hp;                

  uint hash_from_lsh(int* x);           // compute hash function code from lsh
  
  uint l_loc_from_hash(uint hash, uint wh);      // compute the loc in l based on hash

  uint find(int* lsh_code, uint wh);     // return the pointer to the hp entry;
                                         // UINT_NULL if not find
  void insert(uint t_hp, uint hash_code, uint wh);   // insert the HashPointer t_hp (pointer) to l[wh] with hash code hash_code
  void move_out(uint t_hp, int* lsh_code, uint wh);   // move out HashPointer t_hp from the corresponding bucket in l[wh]

  HashTable(uint K, uint L, uint hash_size = 999983); // 997 smch: constructor
  //~HashTable();                            // smch: deconstruct

  void clean_up_l_list();

  // debug purpose
  //void print_hash_table(UnionFindDelete& inv, const char* bucket_out);
  void print_hash_table_v2();
};


class OneStep{
public:
  uint vals_len;                      // the length of an array including
                                      // the pixel and its neighbors
  uint value_table_size;              // the value table size (for initialization)

  uint num_items;                     // the number of items

  uint K, L;                          // K and L for LSH

  PNBucketBank pnb;

  HashTable hash_t;                   // hash table

  LocalitySensitiveHashing lsh;       // lsh
  
  UnionFindDelete inv;                // inverse table; union-find structure

  valueType* old_v;                   // old value table
  valueType* new_v;                   // new value table

  EnumHashTable item2hp_hash;
  
  vector< vector< uint > > item2hp_id;                 // from item (encoded from Coordinate) to the hash pointer id in each hash table (values only valid for items which are the root in inv)  // This is what it needs to be re-done. one item may have multiple hp in each of the L HashPointer class.  arrangement: [item][cl]
  

public:
  OneStep(uint _vals_len, uint _value_table_size, uint _num_items, uint _K, uint _L, valueType lsh_r); 
  ~OneStep();                    

  virtual void grab_vals(uint c, valueType* value_table, valueType* vals) = 0; 
  virtual void forward_one_step(valueType* vals, uint c, valueType* new_v) = 0;
  // basically perform: new_v[c_new] = old_v[c_old];
  virtual void assign_vals(valueType* old_v, uint c_old, valueType* new_v, uint c_new) = 0;
  
  virtual void merge_neighbor_into_n_list(uint c, PNBucket* t) = 0;  
  virtual void move_out_neighbor_from_n_list(uint c, PNBucket* t) = 0; 

  void next();
  //void merge_with_same_lsh();
  void merge_with_same_lsh_v2();   // a better implementation.
  void process_active_elem(uint active_elem);

  // debug purpose
  void check_non_empty_item2hp();

  void print_PNBuckets_to_file(const char* bucket_file);
};


valueType inner_product(const valueType* a, const valueType* b, uint len);

class SpinodalDecompOneStep : public OneStep {
  static const uint vals_len = 13;
  static const uint lap_len = 5;
  //static const valueType lsh_r; //= 1e-4;
  
  static const int dx[]; // = {0, 1, 0,-1, 0, 1,-1, 1,-1, 2, 0,-2, 0};
  static const int dy[]; // = {0, 0, 1, 0,-1, 1, 1,-1,-1, 0, 2, 0,-2};

  static const valueType laplapw[]; // = {20,-8,-8,-8,-8,2,2,2,2,1,1,1,1};
  static const valueType lapw[]; // = {-4, 1, 1, 1, 1};

  valueType lsh_r;
  int size;
  uint K, L;

  valueType A, kappa, M, dt, h, h2, h4;

 public:
  SpinodalDecompOneStep(valueType lsh_r, uint size, uint _K, uint _L, valueType A, \
                        valueType kappa, valueType M, valueType dt, valueType h);
  //~SpinodalDecompOneStep();

  void grab_vals(uint c, valueType* value_table, valueType* vals) override; 
  void forward_one_step(valueType* vals, uint c, valueType* new_v) override; 

  void assign_vals(valueType* old_v, uint c_old, valueType* new_v, uint c_new) override;
  void move_out_neighbor_from_n_list(uint c, PNBucket* t) override;
  void merge_neighbor_into_n_list(uint c, PNBucket* t) override;
  
  void encode_from_img(valueType** img); 
  valueType** decode_to_img();  
};



#endif //C_IMPLEMENT_NANOVOID_H
